(function (root) {

    var ps = root.ps || {};
    var config = {};
    var translation = null;

    function loadTemplates(templateNames) {

        for (var templateIndex in templateNames) {
            var templateName = templateNames[templateIndex];
            jQuery.ajax({
                type: 'GET',
                url: config.templatePath + templateNames[templateIndex] + '.dust',
                async: false,
                dataType: "text",
                success: function (testTempl) {
                    dust.loadSource(dust.compile(testTempl, templateName));
                },
                error: function (xhr) {
                    config.onError(xhr);
                }
            });
        }
    }

    ps.questionary = function (settings) {

        config = {
            translation: settings.translation || null,
            templatePath: settings.templatePath || '/questionary/templates/',
            container: settings.container,
            buildUrl: settings.buildUrl,
            saveUrl: settings.saveUrl,
            currentTab: 'document-0',
            errorClass: 'questionnaire-error-msg',
            hideAnswered: settings.hideAnswered || false,
            beforeReload: settings.beforeReload || function () {
                // empty by default
            },
            afterReload: settings.afterReload || function () {
                // empty by default
            },
            onFinish: settings.onFinish || function () {
                // empty by default
            },
            onQuestionaryNotFound: settings.onQuestionaryNotFound || function () {
                // empty by default
            },
            onError: settings.onError || function () {
                // empty by default
            }
        };

        if (config.translation === null)
        {
            config.translation = config.templatePath;
            config.translation = config.translation.split('templates')[0] + "translations/de.json";
        }

        var data = {
            conditions: {},
            variables: {}
        };

        function initEventListeners() {
            if (!ps.listenersInitialized) {
                // Save button
                $('body').on('click', '.saveQuestionnaire', function () {
                    saveAnswer(this);
                });

                // On choose radion option in a radio question
                $('body').on('change', '.question input[rel=radio]', function () {
                    saveAnswer(this);
                });
                $('body').on('click', '.checkmark', function () {
                    if($(this).parent().closest(".question").hasClass("edit")){
                        $(this).parent().find('input').attr('checked', 'checked');
                        saveAnswer($(this).parent().find('input'));
                    }
                });
                // On choose radion option in a yes/no question
                $('body').on('change', '.question input[rel=yesno]', function () {
                    saveAnswer(this);
                });

                $('body').on('click', '.editVariables', function () {
                    var questionHolder = $($(this).data('holderidentificator'));

                    questionHolder.addClass('edit');
                    questionHolder.removeClass('answered');
                    variablesShowSaveButton($(this));
                });

                // On select document in the left bar
                $('body').on('click', '.questionnaire-nav a', function () {
                    tabsNavigation(this);
                });

                // On click save variables button in a variables section
                $('body').on('click', '.saveVariables', function () {
                    var inputs;
                    var variables = $(this).parent();
                    var isValid = true;

                    $(variables).each(function (key, variableM) {
                        if (hasContainerValues($(variableM))) {
                            //remove error class
                            $(variableM).removeClass('error-focus');

                            //collect data from inputs or textareas
                            if ($(variableM).find('textarea').length > 0) {
                                //textarea
                                var textarea = $(variableM).find('textarea');
                                collectVariableData(textarea);
                            }
                            inputs = $(variableM).find('input');
                            $.each($(inputs), function (key, input) {

                                collectVariableData(input);
                            });
                        } else {
                            isValid = false;
                            variableError($(variableM));
                            $(variableM).addClass('error-focus');
                        }
                    });
                    if (isValid) {
                        ps.sendAnswers();
                    }
                });

                // Main questionary save button
                $('body').on('click', '#submitQuestionnaire', function (e) {
                    if ($('#submitQuestionnaire').hasClass('active')) {
                        config.onFinish();
                    }
                });

                // Edit answered question
                $('body').on('click', '.editQuestionnaire', function () {
                    var questionHolder = $(this).data('holderidentificator');

                    $(questionHolder).removeClass('answered');
                    $(questionHolder).addClass('edit');
                    disableAllVariableContainers(true);
                    editQuestion(this);
                });

                // On click "Forward" button at the and of the document
                $('body').on('click', '.nextDocument', function () {
                    var nextTabInt = parseInt(classConvertor(config.currentTab)) + 1;
                    var nextTabRel = selectRightDocument(nextTabInt, true);
                    var navElement = $('[rel="' + nextTabRel + '"]');
                    tabsNavigation(navElement);
                });

                // On click "Back" button at the and of the document
                $('body').on('click', '.prevDocument', function () {
                    var prevTabInt = parseInt(classConvertor(config.currentTab)) - 1;
                    var prevTabRel = selectRightDocument(prevTabInt, false);
                    ;
                    var navElement = $('[rel="' + prevTabRel + '"]');
                    tabsNavigation(navElement);
                });

                // Change show only unanswered questions option
                $('body').on('change', '#hideAnswered', function () {
                    config.hideAnswered = $(this).is(':checked');
                    loadQuestionary();
                });

                ps.listenersInitialized = true;
            }
        }

        function init() {

            $.ajax({
                type: 'GET',
                url: config.translation,
                success: function(res) {
                    translation = res;
                    loadTemplates(['questionary', 'question', 'variable']);
                    loadQuestionary();
                },
                error: function(err) {
                    console.log(err);
                }
            });

            initEventListeners();
        }

        function loadQuestionary() {

            config.beforeReload();

            $.ajax({
                type: 'GET',
                url: config.buildUrl,
                dataType: "json",
                success: function (response) {

                    filterQuestions(response.content.documents);

                    dust.render('questionary', {documents: response.content.documents, config: config, tr: translation, questionaireExplanation: response.content.explanation}, function (err, out) {
                        if (err) {
                            config.onError(err);
                        }
                        $(config.container).html(out);
                    });

                    $els = $('.questionnaire-document').find('.questionnaire-document').detach();
                    $('#questionnaire').append($els);

                    initTabDocuments();
                    initFields();
                    //Tabs 
                    var navElement = $('[rel="' + config.currentTab + '"]');

                    showTab(navElement);

                    var prevNavElement = navElement.parent();
                    if (docValidation(config.currentTab)) {
                        $('.nextDocument').removeClass('inactive').addClass('active');
                    }
                    else {
                        $('.nextDocument').removeClass('active').addClass('inactive');
                    }

                    var complete = isEveryThingAnswered();
                    if (complete === false) {
                        $('#hide-answered-warning').hide();
                    }

                    config.afterReload();

                },
                error: function (xhr) {
                    config.onQuestionaryNotFound(xhr);
                }
            });

        }

        function initTabDocuments() {
            var documents = $('.questionnaire-document');

            documents.each(function (index, element) {
                var classNames = $(element).attr('class');
                var documentData = classNames.split(' ');
                var navElement = $('[rel="' + documentData[1] + '"]');

                if (isDocumentEmpty(element)) {
                    navElement.parent().hide();
                } else {
                    navElement.parent().show();
                }
            });

            $( ".questionnaire-nav .nav-text" ).each(function() {
                if(this.innerText.length >= 70){
                    $(this).parent().css('min-height', '65px')
                    $(this).addClass("big-text");
                }
            });
        }

        function isDocumentEmpty(container) {

            var questions = $(container).find('.question');
            var variables = $(container).find('.variables-container');

            if (!questions.length > 0 && !variables.length > 0) {
                return true;
            }

            return false;
        }

        /*
         * Tabs initialization
         */
        function initTabs() {

            var documents = $('.questionnaire-document');
            var docNavElements = $('.questionnaire-nav li a:visible');

            hideDocuments();

            var isFirst = true;
            documents.each(function (index, document) {
                if (!isDocumentEmpty(document) && isFirst) {
                    $(document).show();
                    isFirst = false;
                }
            });

            //select first navigation tab 
            docNavElements.first().addClass('selected');

            //sets the first tab as current
            setCurrentTab(docNavElements.first().attr('rel'));

            $('.questionnaire-nav a').click(function () {
                tabsNavigation(this);
            });

            colorizeTabs();
            isEveryThingAnswered();
        }

        function hideDocuments() {
            $('.questionnaire-document').hide();
        }

        /**
         * Sets current tab
         * @param {string} value
         */
        function setCurrentTab(value) {
            config.currentTab = value;
        }

        /*
         * Colorize tabs 
         */
        function colorizeTabs() {
            $('.questionnaire-nav li a').each(function (index, element) {
                var className = $(element).attr('rel');
                if (docValidation(className)) {
                    $(element).parent().addClass('tab-success');
                }
            });
        }

        /**
         * Tabs navigation /forward, backward/
         * 
         * @param {DOM} navElement
         */
        function tabsNavigation(navElement) {
            var questionContainer = $(navElement).attr('rel');
            if (classConvertor(questionContainer) > classConvertor(config.currentTab)) {
                //next tab
                //var documentContainer = $('.' + config.currentTab);
                //var questions = $('.' + config.currentTab + ' .question');
                //var variables = $('.' + config.currentTab + ' .question-variable');

                setCurrentTab(questionContainer);
                showTab($(navElement));
                $("html, body").animate({
                    scrollTop: $(".questionary-container").offset().top
                }, 500);

            } else if (classConvertor(questionContainer) === classConvertor(config.currentTab)) {
                //current tab

            } else {
                //previous tab
                setCurrentTab(questionContainer);
                showTab($(navElement));
            }

            initButtonNavigation();

        }

        /*
         * Convert string name to int 
         * example: string "document-88" to int "88"
         * @param {className} className
         * @returns {int}
         */
        function classConvertor(className) {
            if (/-/.test(className)) {
                var paramParts = className.split('-');
                return parseInt(paramParts[1]);
            }
        }

        /**
         * Hides all documents and remove 
         * class selection from navigation
         * @param {object} tabNav
         */
        function showTab(tabNav) {
            hideDocuments();
            removeClassNav();
            tabNav.addClass('selected');
            //shows tab container
            $('.' + tabNav.attr('rel')).show();
        }

        function removeClassNav() {
            $('.questionnaire-nav li a').removeClass('selected');
        }

        /**
         * Check every document for answers
         */
        function isEveryThingAnswered() {
            var answered = true;
            $('.questionnaire-nav li').each(function (key, container) {
                var button = $(container).find('a');
                var docElementClass = $(button).attr('rel');
                if (docValidation(docElementClass)) {
                    $(container).addClass('tab-success');

                } else {
                    $(container).removeClass('tab-success');
                    answered = false;
                }
            });

            if (answered) {
                $('#submitQuestionnaire').removeClass('inactive').addClass('active');
            }

            return answered;
        }

        /*
         * Validates document section 
         * @param {string} docElementClass
         * @returns {Boolean}
         */
        function docValidation(docElementClass) {
            var isValid = true;
            var questions = $('.' + docElementClass + ' .question');
            if (!validateQuestions(questions, true)) {
                isValid = false;
            }

            var allVariableContainers = $('.' + docElementClass + ' .question-variable');
            allVariableContainers.each(function (index, variableContainer) {
                if (!hasContainerValues($(variableContainer))) {
                    isValid = false;
                    return false;
                }
            });

            return isValid;
        }

        function isSaved(documentContainer) {
            var dataContainer;
            var isValid = true;
            var sections = documentContainer.find('.questionnaire-section');
            sections.each(function (index, section) {
                dataContainer = $(section).children();
                dataContainer.each(function (key, container) {
                    if (!$(container).hasClass('answered')) {
                        if ($(container).hasClass('question'))
                        {
                            questionError($(container));
                        }
                        if ($(container).hasClass('variables-container'))
                        {
                            var variableContainers = $(container).find('.question-variable');
                            variableContainers.each(function (index, varContainer) {
                                variableError($(varContainer));
                            });
                        }

                        $(container).addClass('error-focus');
                        isValid = false;
                    }
                });
            });

            return isValid;
        }

        /**
         * Has container selected answers
         * @param {string} container
         * @returns {Boolean}
         */
        function hasContainerSelection(container) {
            return $(container).find('input').is(':checked');
        }

        /**
         * Checks for valid question data of the current tab 
         * Checks for valida data when is submit 
         * @param {string} container
         * @param {boolean} removeError
         * @returns {Boolean}
         */
        function validateQuestions(container, removeError) {
            var isValid = true;

            //Checks the radio/checkbox group for selection
            $.each(container, function (key, element) {
                if (!hasContainerSelection(element)) {
                    if (!removeError) {
                        $(element).addClass('error-focus');
                    }
                    isValid = false;
                }
            });

            return isValid;
        }

        /**
         * Checks for valid variable data of the current tab 
         * @param {object} container
         * @returns {Boolean}
         */
        function validateVariables(container) {
            var isValid = true;
            if (!$.isEmptyObject(container)) {
                container.each(function (key, element) {
                    if (!hasContainerValues($(element))) {
                        $(element).addClass('error-focus');
                        isValid = false;
                    }

                });
            }

            return isValid;
        }

        function initButtonNavigation()
        {
            var btnPrev = $('.prevDocument');
            var btnNext = $('.nextDocument');
            var btnFinish = $('#submitQuestionnaire');

            var countedDocs = [];

            $('.questionnaire-document').each(function (index, document) {
                if (!isDocumentEmpty(document)) {
                    countedDocs.push(document);
                }
            });

            var documentFirstData = $(countedDocs).first().attr('class').split(' ');
            var documentLastData = $(countedDocs).last().attr('class').split(' ');

            if (countedDocs.length > 1) {
                if (classConvertor(config.currentTab) === classConvertor(documentFirstData[1])) {
                    btnPrev.hide();
                    btnFinish.hide();
                    btnNext.show();
                    initNextButton();
                } else if (classConvertor(config.currentTab) === classConvertor(documentLastData[1])) {
                    btnNext.hide();
                    btnPrev.show();
                    btnFinish.show();
                } else {
                    btnNext.show();
                    btnPrev.show();
                    btnFinish.hide();
                    initNextButton();
                }
            } else {
                btnNext.hide();
                btnPrev.hide();
                btnFinish.show();
            }

        }

        function initNextButton() {
            if (docValidation(config.currentTab)) {
                $('.nextDocument').removeClass('inactive').addClass('active');
            }
            else {
                $('.nextDocument').removeClass('active').addClass('inactive');
            }
        }

        /**
         * 
         * @param {object} container
         * @returns {Boolean} 
         */
        function hasContainerValues(container) {
            var hasValue = false;
            if (container.find('input').attr('rel') === 'checkbox' || container.find('input').attr('rel') === 'radio') {
                if (container.find('input').is(':checked')) {
                    hasValue = true;
                }
            } else {
                hasValue = true;

                if (container.find('input').length > 0) {
                    container.find('input').each(function (index, element) {
                        if (!$(element).val().length > 0) {
                            hasValue = false;
                        }
                    });
                } else if (container.find('textarea').length > 0) {
                    container.find('textarea').each(function (index, element) {
                        if (!$(element).val().length > 0) {
                            hasValue = false;
                        }
                    });
                }
            }

            return hasValue;
        }

        function questionError(container) {

            if (container.find('input').length > 1) {
                var element = container.find('.' + config.errorClass);
                element.show();
            }
        }

        function variableError(container) {

            if (container.find('input').length > 1) {
                var element = container.find('.' + config.errorClass);
                element.show();
            }
        }

        function selectRightDocument(tabInt, increase) {
            if (typeof (increase) === 'undefined')
                increase = true;

            var document = '.document-' + tabInt;

            if ($(document).length > 0 && isDocumentEmpty(document)) {
                if (increase) {
                    return selectRightDocument(parseInt(tabInt + 1));
                } else {
                    return selectRightDocument(parseInt(tabInt - 1));
                }
            }

            return 'document-' + tabInt;
        }

        function saveAnswer(self) {
            var inputs;
            var questionContainer = $(self).parent();
            if (hasContainerSelection(questionContainer)) {
                inputs = $(questionContainer).find('input');
                $.each($(inputs), function (key, input) {
                    collectQuestionData(input);
                });
                ps.sendAnswers();
            } else {
                questionError(questionContainer);
                $(questionContainer).addClass('error-focus');
            }
        }

        /**
         * Create number and date flieds
         * Disable fields
         * Colorize divs
         */
        function initFields() {
            initButtonNavigation();
            createNumberFields();
            disableQuestions();
            disableAllVariableContainers();
            colorizeAnswered();
            colorizeVariables();
        }

        /**
         * Collect the answered question from the user
         * Sets the post data 
         * @param {DOM element} inputElement
         */
        function collectQuestionData(inputElement) {
            var inputName, inputValue, inputType, isSelected;

            inputType = getInputType(inputElement);
            isSelected = $(inputElement).is(':checked');

            if (inputType == 'checkbox') {
                inputName = $(inputElement).attr('name');

            } else if (inputType == 'yesno' && isSelected) {
                inputName = $(inputElement).attr('name');
                inputValue = $(inputElement).attr('value');
            } else if (inputType == 'radio') {
                inputName = $(inputElement).attr('value');
            }

            if (inputType == 'checkbox' || inputType == 'radio') {
                if (isSelected) {
                    inputValue = '1';
                } else {
                    inputValue = '0';
                }
            }

            if (typeof inputName !== 'undefined') {
                data.conditions[inputName] = inputValue;
            }
        }

        /**
         * Collects all anwsers from draft or submit
         */
        function getAllAnswers() {
            data = {conditions: {}, variables: {}};
            $.each($('.question'), function (key, element) {
                if (hasContainerSelection(element)) {
                    var inputElements = $(element).find('input');

                    inputElements.each(function (key, input) {
                        collectQuestionData(input);
                    });
                }
            });
        }

        /**
         * Get question type /radio, checkbox or yesno/
         * @param {string} element
         * @returns {string}
         */
        function getInputType(element) {
            return $(element).attr('rel');
        }

        /*
         * Send and draft save answers
         */
        ps.sendAnswers = function () {

            config.beforeReload();

            getAllAnswers();
            getAllVariables();

            $.ajax({
                type: 'POST',
                url: config.saveUrl,
                dataType: "json",
                data: {answers: data},
                success: function (response) {
                    loadQuestionary();
                }
            });
        };

        /*
         * Collects all variables 
         */
        function getAllVariables() {

            $.each($('.question-variable'), function (key, element) {
                if (hasContainerValues($(element))) {

                    //collect data from inputs or textareas
                    if ($(element).find('textarea').length > 0) {
                        //textarea
                        var textarea = $(element).find('textarea');
                        collectVariableData(textarea);
                    }

                    var inputs = $(element).find('input');
                    $.each($(inputs), function (key, input) {
                        collectVariableData(input);
                    });

                }
            });
        }

        /**
         * Disable determinations in a Section
         * except the first or if previous is answered
         *
         */
        function disableQuestions() {
            var sections = $('.questionnaire-section');
            $(sections).each(function (index, section) {
                var questions = $(section).find('div.question');

                $(questions).each(function (index, element) {

                    if (hasContainerSelection(element))
                    {
                        //mark as disabled all input fields
                        var inputFields = $(element).find(':input');
                        $(inputFields).each(function (index, element) {
                            $(element).attr('disabled', true);
                        });
                        showEditButton(element);

                    }
                    else if (index != 0 && (!hasContainerSelection(element) && !hasContainerSelection($(this).prev()))) {
                        lockContainer(element);
                    }
                });
            });
        }

        /**
         * Enable edit button
         */
        function showEditButton(question) {
            //$(question).removeClass('edit');
            var buttonSave = $(question).find('.saveQuestionnaire');
            var buttonEdit = $(question).find('.editQuestionnaire');
            buttonSave.addClass('disabled');
            buttonEdit.show();
            buttonEdit.removeAttr('disabled');
        }

        /**
         * Enable save button
         */
        function showSaveButton(question) {
            question.removeClass('answered');
            var buttonEdit = $(question).find('.editQuestionnaire');
            var buttonSave = $(question).find('.saveQuestionnaire');

            buttonEdit.hide();
            buttonSave.removeClass('disabled');
            buttonSave.removeAttr('disabled');
        }

        /**
         * Edit question
         * (enable input fields and 
         * set different background color)
         */
        function editQuestion(button) {
            //curent question
            var questionHolder = $($(button).data('holderidentificator'));

            enableQuestionInputs(questionHolder);
            showSaveButton(questionHolder);
            disableCheckBoxesIfNoneOfTheAboveIsActive(questionHolder);

            //lock other questions
            var questions = $('div.question');
            $(questions).each(function (index, element) {

                if (!$(element).hasClass('edit')) {
                    lockContainer(element);
                }
            });
            $(questionHolder).addClass('edit');
        }

        /**
         * Enable question input fields
         */
        function enableQuestionInputs(question) {
            var inputFields = $(question).find(':input');
            $(inputFields).each(function (index, element) {
                $(element).removeAttr('disabled');
            });
        }

        /**
         * Set question as disabled
         */
        function lockContainer(question) {
//            $(question).fadeTo('slow', .6);
//            $(question).append('<div style="position: absolute;top:0;left:0;width: 100%;height:100%;z-index:2;opacity:0.4;filter: alpha(opacity = 50)"></div>');
        }

        /**
         * Set color for answered questions 
         *
         */
        function colorizeAnswered() {
            $('.question').each(function (index, questionContainer) {
                if (hasContainerSelection(questionContainer)) {
                    $(questionContainer).addClass('answered');
                }
            });
        }

        /**
         * Create input only numeric input fields
         */
        function createNumberFields() {
            $('input.numberInput').bind('keypress', function (e) {
                // Allow only certain characters
                // a-z
                var a2z = (e.which >= 97 && e.which <= 122);
                // A-Z
                var A2Z = (e.which >= 65 && e.which <= 90);
                return !(a2z || A2Z);
            });
        }

        /**
         * @returns {undefined}
         */
        function disableAllVariableContainers(force) {
            var sections = $('.questionnaire-section');
            $(sections).each(function (index, section) {
                if (!validateSection(section) || force == true) {
                    var variables = $(section).find('div.question-variable');

                    $(variables).each(function (index, element) {
                        lockContainer($(element).parent());
                    });
                } else {

                }
            });
        }

        /**
         * Validate answers by section
         * 
         * @param {DOM element} section
         * @returns {Boolean}
         */
        function validateSection(section) {
            var isValid = true;
            var questions = $(section).find('div.question');

            $(questions).each(function (index, question) {
                $.each($(question), function (key, field) {
                    if (!hasContainerSelection(field)) {
                        isValid = false;
                    }
                });
            });

            return isValid;
        }

        /**
         * Collect the answered variables from the user
         * Sets the post data 
         * @param {DOM element} element
         */

        function collectVariableData(element) {
            var inputType = $(element).attr('rel');
            var inputName = $(element).attr('name');
            // TODO: remove date fix after proper date validation
            if ((inputType == 'text' || inputType == 'date') && $(element).val().length > 0) {
                data.variables[inputName] = $(element).val();
            } else if (inputType == "radio") {
                var checkedInput = $(element).is(':checked');
                if (checkedInput) {
                    data.variables[inputName] = $(element).attr('value');
                }
            } else if (inputType == "checkbox") {
                var checkedInput = $(element).is(':checked');
                var inputValue = $(element).attr('value');

                if (checkedInput) {
                    if (!data.variables[inputName]) {
                        data.variables[inputName] = new Array();
                    }
                    if (jQuery.inArray(inputValue, data.variables[inputName]) == -1) {
                        data.variables[inputName].push($(element).attr('value'));
                    }

                } else {
                    //remove item if is unchecked and has value in array
                    var indexToRemove = jQuery.inArray(inputValue, data.variables[inputName]);
                    if (indexToRemove != -1) {
                        data.variables[inputName].splice(indexToRemove, 1);
                    }

                    //delete array if is empty
                    if (data.variables[inputName] && data.variables[inputName].length == 0) {
                        delete data.variables[inputName];
                    }
                }
            }
        }

        /**
         * 
         */
        function colorizeVariables() {
            var variablesContainer = $('.variables-container');
            variablesContainer.each(function (index, element) {
                if (hasContainerValues($(element))) {
                    $(element).addClass('answered');
                    variablesShowEditButton($(element));
                }
            });
        }

        /**
         * Enable edit button
         * @param {object} container
         */
        function variablesShowEditButton(container) {
            var buttonSave = container.find('.saveVariables');
            var buttonEdit = container.find('.editVariables');

            buttonSave.addClass('disabled');
            buttonSave.attr('disabled', true);
            buttonEdit.show();
            buttonEdit.removeAttr('disabled');

            disableAllVariableInputs(container, true);
        }

        /**
         * Disable or enable variable inputs
         * 
         * @param {object} container
         * @param {boolean} flag
         */
        function disableAllVariableInputs(container, flag) {
            var variables = container.find('.question-variable');
            variables.each(function (index, element) {
                var inputs = $(variables).find('input');
                $(inputs).each(function (key, input) {
                    $(input).attr('disabled', flag);
                });

                var textarea = $(variables).find('textarea');
                $(textarea).each(function (key, input) {
                    $(input).attr('disabled', flag);
                });
            });
        }

        /**
         * Show save button 
         * in variables container
         * 
         * @param {object} button
         */
        function variablesShowSaveButton(button) {

            var buttonSave = $(button.data('save-button-identificator'));
            button.hide();

            buttonSave.removeAttr('disabled');
            buttonSave.removeClass('disabled');

            disableAllVariableInputs(buttonSave.parent(), false);

            //lock all questions
            var questions = $('div.question');
            $(questions).each(function (index, element) {
                lockContainer(element);
            });
        }

        function isEmail(email) {
            var regExp = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            return regExp.test(email);
        }

        function filterQuestions(documents) {

            if (config.hideAnswered) {
                $.each(documents, function (docIndex, doc) {
                    $.each(doc.sections, function (sectionIndex, section) {
                        // If any question/variable is shown in this section,
                        // it should set the flag to false in the iteration below
                        section.hidden = true;

                        // Hide questions
                        $.each(section.questions, function (qIntex, question) {
                            question.hidden = false;
                            switch (question.type) {
                                case "radio":
                                    $.each(question.options, function (optIntex, option) {
                                        if (option.value == "1") {
                                            question.hidden = true;
                                        }
                                    });
                                    break;
                                case "yesno":
                                    $.each(question.options, function (optIntex, option) {
                                        if (option.value !== undefined) {
                                            question.hidden = true;
                                        }
                                    });
                                    break;
                                case "checkbox":
                                    $.each(question.options, function (optIntex, option) {
                                        if (option.value == "1") {
                                            question.hidden = true;
                                        }
                                    });
                                    break;
                            }
                            if (!question.hidden) {
                                section.hidden = false;
                            }
                        });
                        // Hide variables
                        $.each(section.variables, function (varIntex, variable) {
                            variable.hidden = false;
                            switch (variable.type) {
                                case "singleline":
                                case "multiline":
                                case "number":
                                case "date":
                                    if (typeof variable.value !== "undefined") {
                                        variable.hidden = true;
                                    }
                                    break;
                                case "radio":
                                    $.each(variable.options, function (optIntex, option) {
                                        if (option.key === variable.value) {
                                            variable.hidden = true;
                                        }
                                    });
                                    break;
                                case "checkbox":
                                    $.each(variable.options, function (optIntex, option) {
                                        if ($.inArray(option.key, variable.value) >= 0) {
                                            variable.hidden = true;
                                        }
                                    });
                                    break;
                                case "bulletpoint":
                                    if (variable.value && variable.value.length > 0) {
                                        variable.hidden = true;
                                    }
                                    break;
                            }
                            if (!variable.hidden) {
                                section.hidden = false;
                            }
                        });
                    });
                });
            }
        }

        function disableCheckBoxesIfNoneOfTheAboveIsActive(questionContainer) {
            questionContainer.find('.checkList').each(function(){
                if ($(this).find('input').attr('id').search('noneOfTheAbove') > 0 && $(this).find('input').is(':checked')) {
                    questionContainer.find('.checkList input').attr('disabled', true);
                    questionContainer.find('.checkList input').prop('checked', false);

                    $(this).find('input').attr('disabled', false);
                    $(this).find('input').prop('checked', true);;
                }
            });
        }

        return init();

    };

    ps.documents = function (settings) {

        config = {
            templatePath: settings.templatePath || '/questionary/templates/',
            container: settings.container,
            listUrl: settings.listUrl,
            downloadUrl: settings.downloadUrl
        };

        function init() {

            loadTemplates(['documents']);

            jQuery.ajax({
                type: 'GET',
                url: config.listUrl,
                async: false,
                dataType: "json",
                success: function (list) {
                    dust.render('documents', {documents: list.content.documents, downloadUrl: config.downloadUrl}, function (err, out) {
                        if (err) {
                            return console.log(err);
                        }
                        jQuery(config.container).html(out);
                    });
                },
                error: function (xhr) {
                    alert('Error!  Status = ' + xhr.status);
                }
            });
        }

        return init();
    };


    root.ps = ps;
}
)(this);